<?php
/*
Plugin Name: Power Online Reviews
Description: Global Version. Generate, manage and display customer ratings, reviews and testimonials on your site. Request reviews on third party sites like GMB, Facebook, Yelp & TripAdvisor etc. 
Version: 3.0.11
tested to WordPress 6.6.* & PHP 8.1.12
Author: Tony Marriott
*/

// Make sure we don't expose any info if called directly

error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
if ( !function_exists( 'add_action' ) ) {
	echo "Hi there!  I'm just a plugin, not much I can do when called directly.";
	exit;
}

define( 'POR_PLUGIN_NAME', 'Feedback Request' );
define( 'POR_PLUGIN_PATH', plugin_dir_path(__FILE__) );
define( 'POR_PLUGIN_URL', plugin_dir_url(__FILE__) );
define( 'POR_SITE_BASE_URL',get_bloginfo('url'));

require_once POR_PLUGIN_PATH.'includes/por_class.php';

register_activation_hook( __FILE__, array( 'POR', 'por_install' ) );
register_deactivation_hook( __FILE__, array( 'POR', 'por_uninstall' ) );





add_action('wp_enqueue_scripts', 'wp_por_display_enqueue_scripts');


add_shortcode('wp_por_display','wp_por_display_handler');

add_filter('widget_text', 'do_shortcode');









function wp_por_display_handler($atts)// what the displayed reviews look like

{	
	$atts=shortcode_atts(array(
									'sidebar' => 'No',
	), $atts);
	
	
	
	
	$por_forms_data=get_option('por_forms_data');
	$position = 0;
	$number_of_results = $por_forms_data['por_review_form_display_max'];
	$footerText = $por_forms_data['por_review_footer_text'];
	$review_rating =$por_forms_data['por_review_form_good_rating'];
	$review_star_image = POR_PLUGIN_URL.'images/rating32.png';
	$review_star_image2 = POR_PLUGIN_URL.'images/blank32.png';
	if ($por_forms_data['por_corner_style'] == 'Round') {
		$review_corners='10px';
	}
	else {
		$review_corners='0px';
	} 
	
	if ($por_forms_data['por_image_style'] == 'Flat') {
		$flat_shadow="-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;";
	}
	$wideReviewStyle=" style=float:left;";
	$wideReview="0";// is a wide review	
	
	//if ($atts['sidebar'] == 'Yes') {// id sidebar display
	//	$sidebar_image="float:none;display: block;";
	//	$sidebar_message="min-height:0px;";
		//$wideReviewStyle="";
		//$wideReview="1";// is a sidebar review
	//}
	
	
	$image_style= 'style="background:' .$por_forms_data['por_review_image_bg'] .'; ' .$flat_shadow .$sidebar_image.'"';
	$message_style= 'color:' .$por_forms_data['por_review_message_color'].';'.$sidebar_message;
	$name_style= 'color:' .$por_forms_data['por_review_name_color'].';';
	$business_type= $por_forms_data['por_business_type'];
	$business_name= $por_forms_data['por_business_name'];
	
	
	$animate=$por_forms_data['por_display_reviews_animate'];
	if ($animate=="yes") {
		// enable animate reviews on hover
		$animateClass="animate";
	}
	
	
	$div_class_short = "por-display-reviews-short";
	$div_class_image = "por-display-reviews-image";
	$div_class_name = "por-display-reviews-name";
	$div_class_rating = "por-display-reviews-rating";
	$div_class_message = "por-display-reviews-message";
	
$reverse_feedback = por_get_reverse_feedback($position,$number_of_results,$review_rating);
 

unset ($multiple_reviews);unset($ii);// set back to start
foreach ($reverse_feedback as $each_review) {
	//loop through all reviews - newest first
	if ($each_review->name !== NULL){
	++$ii;
	if ($ii > $number_of_results) {
		break;
	} // exit at end of reviews.
	// review data
	$review_name = $each_review->name;
	$name_letter=strtoupper(substr($review_name,0,1)); // get first letter of name
	$review_rating = $each_review->rating;
	$review_message = $each_review->message;
	$review_date = $each_review->created;
	$round_color=""; // generate a random dark color
	for ($o=1;$o<=3;$o++) {
		$round_color .= str_pad( dechex( mt_rand( 0, mt_rand(0,255 )) ), 2, '0', STR_PAD_LEFT);
	}
	$imageNumber=$ii;// cycle images * 10 to fill all reviews
	for ($im = 1; $im <= 40; $im++) {
		if ($imageNumber <= 10) {
			break;
		}
		$imageNumber=$imageNumber-10;
	}


	$review_image =  $por_forms_data['por_display_review'.$imageNumber.'_image']; // select image for review

	unset($review_star); // create star rating image string
	for ($i = 1; $i <= 5; $i++) {
		if ($i > $review_rating) {
			$review_star = $review_star .'<img src=' .$review_star_image2 .' style="width:28px;">';
		} else {
			$review_star = $review_star .'<img src=' .$review_star_image .' style="width:28px;">';
		}
	}



	$dots="......";

	if ($ii !== $wideReview) {
		// All reviews for page.

		$multiple_reviews = $multiple_reviews
		.'<div '.$wideReviewStyle.'">
<div style="position:relative;" class="'.$animateClass.'" id="review-box">


	<div class="' .$div_class_image .'" ' .$image_style .'>
	<div class="" style="font-size:24px;font-weight:600;color:white;background-color:#'.$round_color.';width:35px;height:35px;border-radius:50%;padding:5px;margin-left:20px;margin-top:20px;display:flex;align-items : center;text-align:center;justify-content: center;">' .'<div >'.$name_letter.'</div>' .'</div>

	<div class="'.$div_class_message.'" style="'.$message_style.'font-size:10px;position:absolute; left:60px; top:20px;">' .date('Y-m-d',$review_date) .'</div>

	<div class="' .$div_class_name .'" style="'.$name_style.'font-weight:600; ">' .strtolower(substr($review_name, 0, 22)) .'</div>
	</div>
	<div class="' .$div_class_rating .'" style="position:absolute; left:10px; top:115px;" >' .$review_star .'</div>
	<div class="' .$div_class_message .'" style="'.$message_style.'position:absolute; left:10px; top:145px;line-height:1.2em;">
		<div style="max-width:210px;" property="reviewBody">' .substr($review_message, 0, 150) . $dots.' </div>
	</div>
</div>

		    <div class="spacer"> </div>
		    </div>';
		if ($wideReview == 0) {
			//auto call multiple reviews
			$callMultiple="<script>showMultiple();</script>";
		}
	}// end multiple reviews
}			

} // end all reviews
if ($number_of_results > 0){// we have actual reviews so add avg reviews + footer 
$multiple_reviews = $multiple_reviews . '
<div class="" style="'.$name_style.'text-align:center;">'.$each_review.'</div>
<div>'.$footerText.'</div>';
}


	$output = <<<EOT

  

<link rel="stylesheet" type="text/css" href="http://fonts.googleapis.com/css?family=Pacifico|Cuprum|Roboto Condensed">

<style>

.spacer {
		display: block;
		min-height: 2em;
}

.open-close {
		display: block;
		font-family: 'Cuprum', serif;
		font-size: 1.2em;
		font-weight:600;
		padding:5px;
		list-style-type:none;
}
.box {
    width 100%
       background-color: #f90;
      /* the CSS, above, is all for aesthetic purposes, what matters is the following */
    opacity: 1;
    -webkit-transition: all 1s linear;
    -ms-transition: all 1s linear;
    -moz-transition: all 1s linear;
    -0-transition: all 1s linear;
    transition: all 1s linear;
    //max-height:10px;
    overflow:hidden;
    border-radius:$review_corners;
}

.box:target {
    opacity: 1;
    -webkit-transition: all 1s linear;
    -ms-transition: all 1s linear;
    -moz-transition: all 1s linear;
    -0-transition: all 1s linear;
    transition: all 1s linear;
    max-height: 100%;
    border-radius:$review_corners;
    border: 1px solid $por_forms_data[por_review_border_color];
}

.por_reviews_container {

	width:100%;
	background-color:#f5fbb7;
	word-break :normal;
	border-radius:$review_corners;
	//border: 1px solid $por_forms_data[por_review_image_bg];
}


.por-display-reviews-short{
	
	width:100%;
	
	
	
}

.por-display-reviews-image {
	
	//padding:5px;
	
	margin-left:10px;
	Margin-right:15px;
	margin-top:15px;
	float:left;
	display: inline;
	vertical-align:top;
	width:230px;
	min-height:250px;
	overflow:hidden;
	border:0px !important;
	border-radius:$review_corners;
	//-webkit-box-shadow:
		//8px 10px 10px rgba(0,0,0,0.5),
		//inset 8px 10px 10px rgba(255,255,255,0.75);
	//-moz-box-shadow:
		//8px 10px 10px rgba(0,0,0,0.5),
		//inset 8px 10px 10px rgba(255,255,255,0.75);
	//box-shadow:
		//8px 10px 10px rgba(0,0,0,0.5),
		//inset 8px 10px 10px rgba(255,255,255,0.75);
	//background:#ccc;
}

.animate :hover{
	margin-top:10px;
	
}



.por-display-reviews-image img{
	width:100%;
	height:200px;
	border-radius:$review_corners;
	border:0px !important;
	
	}
.por-display-reviews-name {
	
	padding-left:20px;
	padding-top:10px;
	margin-left:0px;
	margin-top:-0px;
	z-index: 999;
	font-family: 'arial', sans serif;
        font-size: 16px;
		color:red;
		display: block;
		max-width:230px;
		word-break: break-all;
}


.por-display-reviews-rating {
	padding-left:10px;
	margin-left:1px;
	display: block;
	
}

.por-display-reviews-message {
	font-family: arial,sans-serif;
	font-size: 14px;
	padding-left:10px;
	color:green;
	margin-left:auto; margin-right:0px;
	margin-top:5px;
	min-height:100px;

	
}

</style>
<script>
		function showMultiple() {
		document.getElementById("one").style.opacity="1";
		document.getElementById("one").style.maxHeight="100%";
		document.getElementById("one").style.border="1px solid $por_forms_data[por_review_border_color]";
		document.getElementById("moreLink").style.display="none";
	}
		function hideMultiple() {
		document.getElementById("one").style.opacity="0";
		document.getElementById("one").style.maxHeight="10px";
		document.getElementById("one").style.border="0px solid $por_forms_data[por_review_border_color]";
		document.getElementById("moreLink").style.display="block";
		}
		
		</script>







	
    			
       			
    			<div class="box" id="one" style="background-color: $por_forms_data[por_review_multiple_bg];">
				$callMultiple
				
          	 $multiple_reviews
          	 </div>
		     		
    			

EOT;

	return $output; 

}



function wp_por_display_enqueue_scripts()

{

	if (!is_admin()) 

    {

    	wp_enqueue_script('jquery');

    	//wp_register_script('jquery-tools', POR_PLUGIN_URL.'js/jquery.tools.min.js');

	    wp_enqueue_script('jquery-tools');

    	//wp_register_style('wp-por-display-style', POR_PLUGIN_URL.'/css/por-display.css');

        wp_enqueue_style('wp-por-display-style');	
        
        
		wp_register_script(  'google-plus', 'https://apis.google.com/js/plusone.js' );

	
		wp_enqueue_script( 'google-plus');





    }	

}

//function por_get_reverse_feedback($position,$number_of_results,$review_rating)
function por_get_reverse_feedback($position,$number_of_results,$review_rating)

 {
// AND message != '' 
		$review_rating=1; // display all reviews 1-5

		global $wpdb;

		$sql = "SELECT * FROM ".$wpdb->prefix."por_feedback  
		WHERE rating >=". $review_rating ."
		
		 order by id desc limit ". $position.", ".$number_of_results;
	

		$reverse_feedback = $wpdb->get_results( $sql );
		
		
		$sql = "SELECT rating FROM ".$wpdb->prefix."por_feedback";
		$allRating = $wpdb->get_results( $sql );
		
		$por_forms_data=get_option('por_forms_data');
		
		$averageRating=round(array_sum(array_column($allRating,'rating'))/count($allRating),1);
		$ratingMessage='<div style="clear:both;display:block;padding-top:10px;"> </div>'.$por_forms_data["por_review_score_text"].': <strong>'.$averageRating.'</strong>';
$reverse_feedback['rating']=$ratingMessage;// add average ratings message to return array
		return $reverse_feedback;

	}
	
	function por_process_local_review_form(){

		if(isset($_POST['por_submit']) && $_POST['por_submit'] != "" ) {

			

			if( $_POST['por_fid'] !="" && $_POST['por_message'] !="" && is_numeric( $_POST['por_fid'] ) ) {

				global $wpdb;

				$sql = "UPDATE `".$wpdb->prefix."por_feedback` SET `message` = '".$this->por_make_safe( $_POST['por_message'] )."' 
				WHERE id = '".$_POST['por_fid']."'";

				$wpdb->query($sql);

				return 'Thank you for helping us get even better. Your feedback has been received and we will respond shortly.';

			}else{

				return 'Please provide valid data for all fields!';

			}

		}

	}
	
	
	
	// create api for agency Client Finder Get Reviews
add_action( 'rest_api_init', function () {
  register_rest_route( 'power-online-reviews/v1', '/get-reviews', array(
    'methods' => 'GET',
    'callback' => 'getReviews',
  ) );
} );
	
	// create api for agency Client Finder Delete Review
add_action( 'rest_api_init', function () {
  register_rest_route( 'power-online-reviews/v1', '/delete-review', array(
    'methods' => 'get',
    'callback' => 'deleteReview',
  ) );
} );
	
	include("feedback-api.php");
	
	//get all acf reviews
	function getReviews() {
		$por_forms_data=get_option('por_forms_data');
		if($_REQUEST['authKey'] == $por_forms_data['por_auth_code']){// only if matching auth keys
  $results= fetchReviews();
  if ( $results=="" ) {
    return null;
  }
	}
  return $results;
}	



	

// delete acf review
	function deleteReview() {
 $removed=removeReview($_REQUEST['id']);
  return $removed;
}	
	
	function removeReview($id) {
global $wpdb;
$sql = "DELETE FROM `".$wpdb->prefix."por_feedback` WHERE id = '".$id."'";
$wpdb->query( $sql );
return $id;
	}		

?>