<?php
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */







/**



 * Class that will hold functionality for plugin activation



 *



 * PHP version 8



 *



 * @category   Front Side Code



 * @package    Power Online Reviews



 * @author     Tony Marriott



 * @version    1.0.0



 * @since      File available since Release 1.0.0



*/







class Por_Front



{



	//Front side starting point. Will call appropriate front side hooks



	public function __construct() {



		



		add_shortcode( 'por_form', array( $this, 'por_form' ) );



		add_shortcode( 'por_bad_review_form', array( $this, 'por_bad_review_form' ) );



		add_shortcode( 'por_good_review_form', array( $this, 'por_good_review_form' ) );

		add_shortcode( 'por_internal_review_form', array( $this, 'por_internal_review_form' ) );

		

			}



	private function por_make_safe( $variable ) {
global $wpdb;

		$variable = $this->por_strip_html_tags($variable);
		// if already escaped remove slashes
		$variable = stripslashes($variable);
		$variable = stripslashes($variable);
		
		//delete possible sql injection characters
		$bad = array("=","<", ">", "/","\"","`","~","$","%","#");
		$variable = str_replace($bad, "", $variable);
		// Replace multiple ' with single '
		$variable= preg_replace('~\'{2,}~', '\'', $variable);
		//remove any slashed at front or rear of string
		$variable=trim($variable, '\\');
		//corectly escape and quote the string
		//$variable = mysql_real_escape_string(trim($variable));
		$variable=$wpdb->prepare("%s",trim($variable ));
		return $variable;


	}



	



	private function por_strip_html_tags( $text ) {



		$text = preg_replace(



			array(



			  // Remove invisible content



				'@<head[^>]*?>.*?</head>@siu',



				'@<style[^>]*?>.*?</style>@siu',



				'@<script[^>]*?.*?</script>@siu',



				'@<object[^>]*?.*?</object>@siu',



				'@<embed[^>]*?.*?</embed>@siu',



				'@<applet[^>]*?.*?</applet>@siu',



				'@<noframes[^>]*?.*?</noframes>@siu',



				'@<noscript[^>]*?.*?</noscript>@siu',



				'@<noembed[^>]*?.*?</noembed>@siu'



			),



			array(



				'', '', '', '', '', '', '', '', ''), $text );



		  



		return strip_tags( $text);



	}



	



	// Function to safe redirect the page without warnings



	private function por_redirect( $url ) {



		



		echo '<script language="javascript">window.location.href="'.$url.'";</script>';



		exit();



	}



	



	private function por_process_review_form(){



		if(isset($_POST['por_submit']) && $_POST['por_submit'] != "" ) {



			



			if( $_POST['por_fid'] !="" && $_POST['por_message'] !="" && is_numeric( $_POST['por_fid'] ) ) {



				global $wpdb;



				$sql = "UPDATE `".$wpdb->prefix."por_feedback` SET `message` = ".$this->por_make_safe( $_POST['por_message'] )." WHERE id = '".$_POST['por_fid']."'";



				$wpdb->query($sql);



				return 'Thank you for helping us get even better. Your review has been received.';



			}else{


				return 'Please provide valid data for all fields!';



			}



		}



	}



	



	private function por_process_form( $por_forms_data ){



		



		if(isset($_POST['por_submit']) && $_POST['por_submit'] != "" ) {



			



			if( $_POST['por_name'] !="" && $_POST['por_email'] !="" ) {



				



				global $wpdb;



				



				$exclude = array( 'por_submit' );



				



				$attributes = '';



				$values = '';



				



				foreach( $_POST as $key=>$value ) {



					if( !in_array( $key, $exclude ) ) {



						$attributes.=", `".str_replace( "por_","",$key )."`";



						$values.=", ".$this->por_make_safe( $value )."";


					}



				}



				



				$sql = "INSERT INTO `".$wpdb->prefix."por_feedback` ( `id`".$attributes.", `created` ) VALUES ( ''".$values.", '".strtotime('now')."' )";



				



				$wpdb->query($sql);



				



				$feedback_id = $wpdb->insert_id;



				



				$page_to_redirect = '';



				



				$good_rating_form_enabled = false;



				for( $i=1; $i<=5; $i++ ) {



					if( $por_forms_data['por_review_site'.$i.'_logo'] !="" && $por_forms_data['por_review_site'.$i.'_url'] !="" && $por_forms_data['por_review_site'.$i.'_display']=='Yes' ) {



						$good_rating_form_enabled = true;



					}



				}



				


// drop good rating check so can go to good form when 

				if( $_POST['por_rating'] >= $por_forms_data['por_review_form_good_rating'] && $por_forms_data['por_review_local'] !== 'Yes' ) {



					$page_to_redirect = get_permalink( get_option( 'por_good_review_form_page_id' ) );



				}else{



					$page_to_redirect = get_permalink( get_option( 'por_bad_review_form_page_id' ) );



				}

					if( $_POST['por_rating'] >= $por_forms_data['por_review_form_good_rating'] && $por_forms_data['por_review_local'] == 'Yes' ) { 



					$page_to_redirect = get_permalink( get_option( 'por_internal_review_form_page_id' ) );

				}



				if ( get_option('permalink_structure') != '' ) {



					$page_to_redirect.="?fid=".base64_encode( $feedback_id );



				}else{



					$page_to_redirect.="&fid=".base64_encode( $feedback_id );



				}



				



				$this->por_redirect( $page_to_redirect );



			}else{



				
if ($_POST['por_message'] !== '')
{
	

				return '';
	
}


			}



		}



	}



	



	public function por_good_review_form() {



		



		$html = '';



		



		$por_forms_data = get_option( 'por_forms_data', array() );



		if ($por_forms_data['por_corner_style'] == 'Round'){

			$corner_value = '10px';

		}

		else {

			$corner_value = '0px';

		}



		if( sizeof( $por_forms_data ) > 0 ){



			if(isset( $_GET['fid'] ) && $_GET['fid'] !="" ) {







				$feedback_id = base64_decode( $_GET['fid'] );
				$noEmail=$_GET['noemail'];


				if( !is_numeric($feedback_id) ) {



					$html.= '<h3>Ooops are you doing some hack? :)</h3>';



					return $html;



				}



			}else{



				$html.= '<h3>Ooops are you doing some hack? :)</h3>';



				return $html;



			}



			if( $por_forms_data['por_notification_good']=='Yes' )

			{

				

				$last_feedback = por_get_last_feedback();

				

			$to =$por_forms_data['por_notification_email'];

				$subject = 'Good Review Posted on '. site_url() ;

				$mail_message = 'Someone has posted a review on your site

				giving a star rating equal to or higher than you have set as good.

				You may wish to deal with this review.

				

				Id=' .$feedback_id .'

				Name=' .$last_feedback->name .'

				Email=' .$last_feedback->email .'

				Phone=' .$last_feedback->phone .'

				Rating=' .$last_feedback->rating .'

				

				To access site click here ' .site_url().'/wp-admin/admin.php?page=por_manage_feedback&action=view&id=' .$feedback_id;


			if($noEmail==FALSE){
					wp_mail($to,$subject,$mail_message);
				}
			

			}

			

			$html.='
		<style>
		input[type=submit] {
			border-radius:'.$corner_value .'!important;
			cursor: pointer;
		}
		</style>
		';	



			$html.='<div class="por_form_container" style="'.'padding:'.$por_forms_data["por_follow-up_form_padding"].'px !important;'.'background:'.$por_forms_data['por_review_form_bg'].';border-radius:'.$corner_value .';">';



			



			$html.='<div class="por_review_form_container" style="margin-right:auto;margin-left:auto;border-radius:'.$corner_value .';">';



			



			$html.='<div class="por_review_form_text">'.stripslashes(nl2br(stripslashes($por_forms_data['por_review_form_text'])));
			
			
			if($good_rating_form_enabled){
			$html.='<br>Select by clicking on the logo below.</div>';
			}


			$html.='<div class="por_star_separator"><span></span><i></i><span></span></div>';



			



			$html.='<div class="por_review_form">';



			



			for( $i=1; $i<=5; $i++ ) {



				if( $por_forms_data['por_review_site'.$i.'_logo'] !="" && $por_forms_data['por_review_site'.$i.'_url'] !="" && $por_forms_data['por_review_site'.$i.'_display']=='Yes' ) {



					$html.='<a href="'.$por_forms_data['por_review_site'.$i.'_url'].'" class="por_good_review_logo" target="_blank"><img src="'.$por_forms_data['por_review_site'.$i.'_logo'].'" border="0" style="border-radius:'.$corner_value .';max-height:150px;"></a>';



				}



			}



				



			$html.='</div>';



			



			$html.='</div>';



			



			$html.='</div>';	

			$html.='<div style="min-height:50px;"></div>';

		}



		



		return $html;



	}



	

	

	

	public function por_internal_review_form() {



		



		$html = '';



		$por_forms_data = get_option( 'por_forms_data', array() );



		if ($por_forms_data['por_corner_style'] == 'Round'){

			$corner_value = '10px';

		}

		else {

			$corner_value = '0px';

		}



		$message = '';



		$message = $this->por_process_review_form( $por_forms_data );



		



		if( sizeof( $por_forms_data ) > 0 ){



			if(isset( $_GET['fid'] ) && $_GET['fid'] !="" ) {







				$feedback_id = base64_decode( $_GET['fid'] );



				if( !is_numeric($feedback_id) ) {



					$html.= '<h3>Ooops are you doing some hack? :)</h3>';



					return $html;



				}



			}else{



				$html.= '<h3>Ooops are you doing some hack? :)</h3>';



				return $html;



			}

			if( $por_forms_data['por_notification_good']=='Yes' )

			{

				

				$last_feedback = por_get_last_feedback();

				

			$to =$por_forms_data['por_notification_email'];

				$subject = 'Good Review Posted on '. site_url() ;

				$mail_message = 'Someone has posted a review on your site

				giving a star rating equal to or higher than you have set as good.

				You may wish to deal with this review.

				

				Id=' .$feedback_id .'

				Name=' .$last_feedback->name .'

				Email=' .$last_feedback->email .'

				Phone=' .$last_feedback->phone .'

				Rating=' .$last_feedback->rating .'

				

				To access site click here ' .site_url().'/wp-admin/admin.php?page=por_manage_feedback&action=view&id=' .$feedback_id;



					wp_mail($to,$subject,$mail_message);

			

			}

			$html.='
		<style>
		input[type=submit] {
			border-radius:'.$corner_value .'!important;
			cursor: pointer;
		}
		</style>
		';
			$html.='<div class="por_form_container" style="'.'padding:'.$por_forms_data["por_follow-up_form_padding"].'px !important;'.'background:'.$por_forms_data['por_review_form_bg'].';border-radius:'.$corner_value .';">';



			



			$html.='<div class="por_review_form_container" style="margin-right:auto;margin-left:auto;border-radius:'.$corner_value .';">';



			



			$html.='<div class="por_review_form_text">'.stripcslashes(nl2br(stripslashes($por_forms_data['por_internal_review_form_text'])));



			$html.='<div class="por_star_separator"><span></span><i></i><span></span></div>';



			



			$html.='<form name="por_form" id="por_form" class="por_form" action="" method="post">';



			$html.='<div class="por_review_form">';



			$html.='<div class="por_review_form_left">';



			$html.='<textarea name="por_message" id="por_message" class="por_message"></textarea>';



			$html.='</div>';



			$html.='<div class="por_review_form_right">';



			$html.='<input name="por_fid" id="por_fid" value="'.$feedback_id.'" type="hidden" >';



			$html.='<input type="submit" name="por_submit" value="'.$por_forms_data['por_all_button_text'].'" id="por_submit" style="background-color: '.$por_forms_data['por_bad_review_form_btn_bg_color'].'; color: '.$por_forms_data['por_bad_review_form_btn_color'].'" >';



			$html.='<div class="por_review_form_message">'.$message.'</div>';



			$html.='</div>';



			$html.='</div>';



			$html.='</form>';



			



			$html.='</div>';



			



			$html.='</div>';	

			$html.='<div style="min-height:50px;"></div>';
		}



		



		return $html;



	}



	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	



	public function por_bad_review_form() {



		



		$html = '';


		
		



		$por_forms_data = get_option( 'por_forms_data', array() );



		if ($por_forms_data['por_corner_style'] == 'Round'){

			$corner_value = '10px';

		}

		else {

			$corner_value = '0px';

		}



		$message = '';



		$message = $this->por_process_review_form( $por_forms_data );



		



		if( sizeof( $por_forms_data ) > 0 ){



			if(isset( $_GET['fid'] ) && $_GET['fid'] !="" ) {







				$feedback_id = base64_decode( $_GET['fid'] );
				$noEmail=$_GET['noemail'];

				if( !is_numeric($feedback_id) ) {



					$html.= '<h3>Ooops are you doing some hack? :)</h3>';



					return $html;



				}



			}else{



				$html.= '<h3>Ooops are you doing some hack? :)</h3>';



				return $html;



			}

			if( $por_forms_data['por_notification_bad']=='Yes' )

			{



				$last_feedback = por_get_last_feedback();

				$to =$por_forms_data['por_notification_email'];

				$subject = 'Bad Review Posted on '. site_url() ;

				$mail_message = 'Someone has posted a review on your site

				giving a star rating lower than you have set as good.

				You should address this review as soon as possible.

				

				Id=' .$feedback_id .'

				Name=' .$last_feedback->name .'

				Email=' .$last_feedback->email .'

				Phone=' .$last_feedback->phone .'

				Rating=' .$last_feedback->rating .'

				

				To access site click here ' .site_url().'/wp-admin/admin.php?page=por_manage_feedback&action=view&id=' .$feedback_id;


			if($noEmail==FALSE){
					wp_mail($to,$subject,$mail_message);
				}
					

			}
			$html.='
		<style>
		input[type=submit] {
			border-radius:'.$corner_value .'!important;
			cursor: pointer;
		}
		</style>
		';

		$html.='<div class="por_form_container" style="'.'padding:'.$por_forms_data["por_follow-up_form_padding"].'px !important;'.'background:'.$por_forms_data['por_review_form_bg'].';border-radius:'.$corner_value .';">';



			$html.='<div class="por_review_form_container"   style="margin-left:auto;margin-right:auto;border-radius:'.$corner_value .';">';



			



			$html.='<div class="por_review_form_text">'.stripcslashes(nl2br(stripslashes($por_forms_data['por_bad_review_form_text']))).'</div>';



			$html.='<div class="por_star_separator"><span></span><i></i><span></span></div>';



			



			$html.='<form name="por_form" id="por_form" class="por_form" action="" method="post">';



			$html.='<div class="por_review_form">';



			$html.='<div class="por_review_form_left">';



			$html.='<textarea name="por_message" id="por_message" class="por_message"></textarea>';



			$html.='</div>';



			$html.='<div class="por_review_form_right">';



			$html.='<input name="por_fid" id="por_fid" value="'.$feedback_id.'" type="hidden" >';



			$html.='<input type="submit" name="por_submit" value="'.$por_forms_data['por_all_button_text'].'" id="por_submit" style="background-color: '.$por_forms_data['por_bad_review_form_btn_bg_color'].'; color: '.$por_forms_data['por_bad_review_form_btn_color'].'" >';



			$html.='<div class="por_review_form_message">'.$message.'</div>';



			$html.='</div>';



			$html.='</div>';



			$html.='</form>';



			



			$html.='</div>';



			



			$html.='</div>';	

			$html.='<div style="min-height:50px;"></div>';

		}



		



		return $html;



	}



	



	public function por_form()
	{







		$por_forms_data = get_option( 'por_forms_data', array() );



		if ($por_forms_data['por_corner_style'] == 'Round') {

			$corner_value = '10px';

		} else {

			$corner_value = '0px';

		}









		$message = '';



		$message = $this->por_process_form( $por_forms_data );







		$html="";


		$html.='
		<style>
		input[type=text] {
			max-width:90%;
			padding: 10px !important;
			border-radius:'.$corner_value .';
		margin:10px 0px;
		border: 1px solid '.$por_forms_data["por_main_form_bg"].';
		height:40px;
		}
		input[type=submit] {
			border-radius:'.$corner_value .'!important;
			cursor: pointer;
		}
		</style>
		';
		



		if( sizeof( $por_forms_data ) > 0 ){



			



			$html.='<div class="por_form_container" style=

			"max-width:'.$por_forms_data['por_main_form_width'].'% !important;padding:'.$por_forms_data["por_main_form_padding"].'px !important;background:'.$por_forms_data["por_main_form_bg"].';border-radius:'.$corner_value .';">';



			

			$html.='<div class="por_form_container_left"  style="border-radius:'.$corner_value .';">';



			



			$html.='<div class="por_form_main_image"><p>';



			$html.='<img  style="border-radius:'.$corner_value .';" src="'.$por_forms_data['por_main_form_image'].'"></p>';



			$html.='</div>';



			



			$html.='<div class="por_form_main_text">';



			$html.='<h3>'.stripcslashes(stripcslashes($por_forms_data['por_main_form_text_title'])).'</h3><p>'.stripcslashes(( stripslashes($por_forms_data['por_main_form_text'] ))).'</p>';



			$html.='</div>';



			



			$html.='</div>';//por_form_container_left ended



			



			$html.='<div class="por_form_container_right" style="border-radius:'.$corner_value .';">';



			



			$html.='<form name="por_form" id="por_form" class="por_form por_form_validate" action="" method="post">';



			



			$html.='<div class="por_form_field">';



			$html.='<div class="por_field_title">'.$por_forms_data['por_main_form_name_text'].'<span>*</span></div>';



			$html.='<input type="text" name="por_name" id="por_name">';



			$html.='</div>';



			



			$html.='<div class="por_form_field">';



			$html.='<div class="por_field_title">'.$por_forms_data['por_main_form_email_text'].'<span>*</span></div>';



			$html.='<input type="text" name="por_email" id="por_email" >';



			$html.='</div>';



			



			$html.='<div class="por_form_field">';



			$html.='<div class="por_field_title">'.$por_forms_data['por_main_form_phone_text'].'<span></span></div>';



			$html.='<input type="text" name="por_phone" id="por_phone" >';



			$html.='</div>';
			



			$html.='<div class="por_form_field por_rating_field">';



			$html.='<div class="por_field_title" style="text-align:center;">'.$por_forms_data['por_main_form_cta'].'</div>';



			$html.='<input type="range" min="0" max="5" value="0" step="1" name="por_rating" id="por_rating"><div class="rateit" data-rateit-backingfld="#por_rating"></div>';



			$html.='</div>';



			



			$html.='<div class="por_form_field">';



			$html.='<input type="submit" name="por_submit" value="'.$por_forms_data['por_all_button_text'].'" id="por_submit" style="background-color: '.$por_forms_data['por_main_form_btn_bg_color'].'; color: '.$por_forms_data['por_main_form_btn_color'].'" >';



			$html.='</div>';



			



			$html.='</form>';



			



			$html.='<div class="por_error">'.$message.'</div>';



			



			$html.='</div>';//por_form_container_right ended



			



			$html.='</div>';

			$html.='<div style="min-height:50px;"></div>';

		}



		



		return $html;



	}



}







$por_front = new Por_Front();







function por_get_last_feedback()



 {



		



		global $wpdb;



		$sql = "SELECT * FROM ".$wpdb->prefix."por_feedback order by id desc limit 1";



		$last_feedback = $wpdb->get_row( $sql );



		return $last_feedback;



	}







?>