<?php
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */



/**

 * Class that will hold functionality for plugin activation

 *

 * PHP version 8

 *

 * @category   Admin Side Code

 * @package    Power Online Reviews

 * @author     Tony Marriott

 * @version    1.0.0

 * @since      File available since Release 1.0.0

*/



class Por_Admin

{

	//Admin side starting point. Will call appropriate admin side hooks

	public function __construct() {

		

		add_action( 'admin_menu', array( $this, 'por_admin_menus' ) );

	}



	public function por_admin_menus(){

		
		if(current_user_can('update_plugins'))
		{

		add_menu_page( POR_PLUGIN_NAME, "Online Reviews", "manage_options", 'por_manage_feedback', array( $this, 'por_manage_feedback' ), POR_PLUGIN_URL."images/icon.png");

		add_submenu_page( 'por_manage_feedback', POR_PLUGIN_NAME." :: "."Manage Feedbacks", "Manage Feedbacks", "manage_options",'por_manage_feedback',  array( $this, 'por_manage_feedback' ) );

		add_submenu_page( 'por_manage_feedback', POR_PLUGIN_NAME." :: "."Manage Forms", "Manage Forms", "manage_options",'por_manage_forms',  array( $this, "por_manage_forms" ) );
		}
		
		if(current_user_can('por_manage_reviews'))
		{
			
	
		add_menu_page( POR_PLUGIN_NAME, "Online Reviews", "por_manage_reviews", 'por_manage_feedback', array( $this, 'por_manage_feedback' ), POR_PLUGIN_URL."images/icon.png");

		add_submenu_page( 'por_manage_feedback', POR_PLUGIN_NAME." :: "."Manage Feedbacks", "Manage Feedbacks", "por_manage_reviews",'por_manage_feedback',  array( $this, 'por_manage_feedback' ) );
		
		
		}

	}

	

	public function por_manage_feedback(){

		

		if($_GET['action']=='view' && is_numeric($_GET['id'])){

			

			$feedback = $this->por_get_feedback( $_GET['id'] );

			require_once POR_PLUGIN_PATH.'templates/admin/view_feedback.php';

			

		}else if($_GET['action']=='del' && is_numeric($_GET['id'])){

			

			$this->por_delete_feedback( $_GET['id'] );

			$feedbacks = $this->por_get_feedbacks();

			require_once POR_PLUGIN_PATH.'templates/admin/manage_feedback.php';

		}else{

			$feedbacks = $this->por_get_feedbacks();

			

			require_once POR_PLUGIN_PATH.'templates/admin/manage_feedback.php';

		}

		

	}

	

	public function por_manage_forms(){

		

		if($_POST['btnsave']!=""){

			

			$exclude = array( 'btnsave', 'btnupload' ); 

			

			$por_data = array();

			

			foreach( $_POST as $k=>$v ) {

				

				if( !in_array( $k, $exclude ) ) {

					$por_data[$k] = $v;

				}

			}

			

			update_option( 'por_forms_data', $por_data );

		}

		

		wp_enqueue_script('media-upload');

    	wp_enqueue_script('thickbox');

    	wp_enqueue_style('thickbox');

	

		$por_forms_data = get_option( 'por_forms_data', array() );

		

		require_once POR_PLUGIN_PATH.'templates/admin/manage_forms.php';

		$this->load_javascript();

	}

	

	public function por_export_feedbacks( $feedbacks ) {

		header('Content-Type: text/csv; charset=utf-8');

		header('Content-Disposition: attachment; filename=feedback.csv');



		// create a file pointer connected to the output stream

		$output = fopen('php://output', 'w');



		// output the column headings

		fputcsv($output, array('ID', 'Name', 'Email', 'Phone', 'Rating', 'Message', 'Date Added' ));



		foreach( $feedbacks as $feedback ) {

			fputcsv($output, array($feedback->id, $feedback->name, $feedback->email, $feedback->phone, $feedback->rating, $feedback->message, date( 'Y-m-d H:i:s',$feedback->created ) ));

		}

		exit();

	}

	

	private function por_delete_feedback( $id ) {

		

		global $wpdb;

		$sql = "DELETE FROM `".$wpdb->prefix."por_feedback` WHERE id = '".$id."'";

		

		$wpdb->query( $sql );

		

		return true;

	}

	

	private function por_get_feedback( $id ) {

		

		global $wpdb;

		$sql = "SELECT * FROM `".$wpdb->prefix."por_feedback` WHERE id = '".$id."'";

		

		$feedback = $wpdb->get_row( $sql );

		

		return $feedback;

	}

	

	public function por_get_feedbacks( $where = 1 ) {

		

		global $wpdb;

		$sql = "SELECT * FROM `".$wpdb->prefix."por_feedback` WHERE ".$where;

		

		$feedbacks = $wpdb->get_results( $sql );

		

		return $feedbacks;

	}

	

	private function load_javascript() {

		

		?>

        <script language="javascript">

		jQuery(document).ready(function($) {

			attach_click_to_media_button('image','upload_media_button');

		});

		

		function attach_click_to_media_button(type,obj_class){

			jQuery('.'+obj_class).click(function() {

				upload_media_button =true;

				formfieldID=jQuery(this).prev().attr("id");

				formfield = jQuery("#"+formfieldID).attr('name');

				tb_show('', 'media-upload.php?type='+type+'&amp;TB_iframe=true');

				if(upload_media_button==true){

					var oldFunc = window.send_to_editor;

					window.send_to_editor = function(html) {

						if(type=='image'){

							fileURL = jQuery('img', html).attr('src');

						}else{

							fileURL = jQuery(html).attr('href');

						}

						jQuery("#"+formfieldID).val(fileURL);

						tb_remove();

						window.send_to_editor = oldFunc;

					}

				}

				upload_media_button=false;

			});

		}

		</script>

        <?php

	}

}



$por_admin = new Por_Admin();

?>