<?php
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */



/**

 * Plugin main class that will control the whole skeleton

 *

 * PHP version 8

 *

 * @category   Main

 * @package    Power Online Reviews

 * @author     Tony Marriott

 * @version    1.0.0

 * @since      File available since Release 1.0.0

*/



class POR

{

     

	//Plugin starting point. Will call appropriate actions

	public function __construct() {
		add_action( 'plugins_loaded', array( $this, 'por_init' ) );

	}



	//Plugin initialization

	public function por_init() {

	 

		do_action('por_before_init');

		

		wp_enqueue_script( 'jquery' );

		wp_enqueue_script( 'jquery_rating', POR_PLUGIN_URL.'js/jquery.rateit.js', array( 'jquery' ) );

		wp_enqueue_script( 'por_js', POR_PLUGIN_URL.'js/por.js', array( 'jquery' ) );

		
		$css_form = get_option("por_css_form");
		if ($css_form == "Legacy Form")
			{wp_enqueue_style( 'por_css', POR_PLUGIN_URL.'css/por_nr.css' );}
				
		if ($css_form == "Single Column Form")
			{wp_enqueue_style( 'por_css', POR_PLUGIN_URL.'css/por_1c.css' );}
							
		if ($css_form == "Default Form")
			{wp_enqueue_style( 'por_css', POR_PLUGIN_URL.'css/por.css' );}
			
			if ($css_form == "V2 Default Form")
			{wp_enqueue_style( 'por_css', POR_PLUGIN_URL.'css/por_flex.css' );}				
		
			

			
			
		
		
		wp_enqueue_style( 'por_rating_css', POR_PLUGIN_URL.'css/rateit.css' );

		

		require_once POR_PLUGIN_PATH.'por_front.php';

		

		if(is_admin()){

			

			wp_enqueue_style( 'wp-color-picker' ); 

			wp_enqueue_script( 'wp-color-picker' );

						

			require_once POR_PLUGIN_PATH.'por_admin.php';

			if( $_GET['action'] == 'export' ) {

				$feedbacks = $por_admin->por_get_feedbacks();

				$por_admin->por_export_feedbacks( $feedbacks );

			}

		}

		

		do_action('por_after_init');

	}

 

	//Function will get called on plugin activation

	static function por_install() {

	

		do_action('por_before_install');

		

		require_once POR_PLUGIN_PATH.'includes/por_install.php';

		

		do_action('por_after_install');

	}

 

	// Function will get called on plugin de activation

	static function por_uninstall() {

	

		do_action('por_before_uninstall');

		

		require_once POR_PLUGIN_PATH.'includes/por_uninstall.php';

		

		do_action('por_after_uninstall');

	}

}



$wppor = new POR();

?>